// src/services/tag.service.js
const prisma = require("../config/db");
const slugify = require("../utils/slugify");

async function getAllTags() {
  return prisma.tag.findMany({
    orderBy: { name: "asc" }
  });
}

async function createTag({ name, slug }) {
  if (!name) throw new Error("Tag name is required");

  const finalSlug = slug || slugify(name);

  return prisma.tag.create({
    data: {
      name,
      slug: finalSlug
    }
  });
}

module.exports = {
  getAllTags,
  createTag
};
