// src/services/category.service.js
const prisma = require("../config/db");
const slugify = require("../utils/slugify");

async function getAllCategories() {
  return prisma.category.findMany({
    orderBy: { name: "asc" }
  });
}

async function createCategory({ name, slug }) {
  if (!name) throw new Error("Category name is required");

  const finalSlug = slug || slugify(name);

  return prisma.category.create({
    data: {
      name,
      slug: finalSlug
    }
  });
}

module.exports = {
  getAllCategories,
  createCategory
};
