const jwt = require("jsonwebtoken");
const config = require("../config/env");
const { error } = require("../utils/response");

function authMiddleware(req, res, next) {
  const header = req.headers.authorization;

  if (!header || !header.startsWith("Bearer ")) {
    return error(res, "Unauthorized", 401);
  }

  const token = header.split(" ")[1];

  try {
    const decoded = jwt.verify(token, config.JWT_SECRET);
    req.admin = decoded;
    next();
  } catch (e) {
    return error(res, "Invalid token", 401);
  }
}

module.exports = authMiddleware;
