// src/config/env.js
const path = require("path");
const dotenv = require("dotenv");

// Load .env from project root
dotenv.config({ path: path.join(__dirname, "../../.env") });

// Resolve upload dir to an absolute path
const uploadDirEnv = process.env.UPLOAD_DIR || "./uploads";
const uploadDir = path.isAbsolute(uploadDirEnv)
  ? uploadDirEnv
  : path.join(process.cwd(), uploadDirEnv);

const env = {
  PORT: process.env.PORT || 5000,
  DATABASE_URL: process.env.DATABASE_URL,
  JWT_SECRET: process.env.JWT_SECRET || "heart",
  UPLOAD_DIR: uploadDir    // always absolute and valid
};

if (!env.DATABASE_URL) {
  console.warn("⚠️  DATABASE_URL is not set in .env");
}

module.exports = env;
