// src/app.js
const express = require("express");
const cors = require("cors");
const path = require("path");
const env = require("./config/env");
const errorHandler = require("./middleware/error.middleware");

// PUBLIC routes
const publicPostsRoutes = require("./routes/public/posts.routes");
const publicCategoriesRoutes = require("./routes/public/categories.routes");
const publicTagsRoutes = require("./routes/public/tags.routes");
const publicAuthorsRoutes = require("./routes/public/authors.routes");
const publicSearchRoutes = require("./routes/public/search.routes");

// ADMIN routes
const adminPostsRoutes = require("./routes/admin/posts.routes");
const adminAuthRoutes = require("./routes/admin/auth.routes");
const adminUploadRoutes = require("./routes/admin/upload.routes");
const adminCategoriesRoutes = require("./routes/admin/categories.routes");
const adminTagsRoutes = require("./routes/admin/tags.routes");
const adminAuthorsRoutes = require("./routes/admin/authors.routes");


const app = express();

app.use(cors());
app.use(express.json());
app.use(express.urlencoded({ extended: true }));

// Serve uploads as static files
app.use("/uploads", express.static(env.UPLOAD_DIR));

/**
 * ROOT ROUTE
 * GET /
 */
app.get("/", (req, res) => {
  res.status(200).json({
    success: true,
    message: "Blog API is running 🚀",
    docs: {
      public: {
        posts: "/api/public/posts",
        categories: "/api/public/categories",
        tags: "/api/public/tags",
        authors: "/api/public/authors",
        search: "/api/public/search?q=term"
      },
      admin: {
        login: "/api/admin/auth/login",
        posts: "/api/admin/posts",
        upload: "/api/admin/upload"
      }
    }
  });
});

// PUBLIC API
app.use("/api/public/posts", publicPostsRoutes);
app.use("/api/public/categories", publicCategoriesRoutes);
app.use("/api/public/tags", publicTagsRoutes);
app.use("/api/public/authors", publicAuthorsRoutes);
app.use("/api/public/search", publicSearchRoutes);

// ADMIN API
app.use("/api/admin/posts", adminPostsRoutes);
app.use("/api/admin/auth", adminAuthRoutes);
app.use("/api/admin/upload", adminUploadRoutes);
app.use("/api/admin/categories", adminCategoriesRoutes);
app.use("/api/admin/tags", adminTagsRoutes);
app.use("/api/admin/authors", adminAuthorsRoutes);



// Error handler (must be last)
app.use(errorHandler);

module.exports = app;
